########################################################################
#
#	help\zgdchart.py
#       
########################################################################
__version__='0.5'


def manage_addZGDChart(self, id, title, REQUEST=None):
	"""
	Create a ZGDChart and install it in its parent Folder
	The argument 'self' will be bound to the parent Folder.
	"""


class ZGDChart:
	'''
	A simple chart class which plots SQL data or dtml data.
	The chart plots the first two columns of a SQL query result.

	This product uses gdchart0.94b, which in turn uses gd1.3
	The current version of gd 1.7.3 does not support gif creation due to the Unisys patent.

	Wrapper authored by Chui Tey<a href="mailto:teyc@cognoware.com">&lt;teyc@cognoware.com&gt;</a>.
	
	(c) Cognoware Australia P/L

	Software is provided without warranty.

	Credits:

	gdchart 	- Bruce Verdeaime   <A HREF="http://www.fred.net/brv/chart/">http://www.fred.net/brv/chart/</A>
	
	gdchart.py	- Michael Ray Steed <A HREF="http://members.xoom.com/_XMCM/msteed/software/gdchart.html"> http://members.xoom.com/_XMCM/msteed/software/gdchart.html </A>

        zgdchart.py	- Hung Jung Lu <hungjunglu@hotmail.com> (version 0.4.2.b) - new data method, RPM package
	
	This product was created using mkproduct 0.6 and Zope Simple Skeleton v0.2,
	written by Sebastian L&uuml;hnsdorf (<a href="mailto:basti@beehive.de">basti@beehive.de</a>)

	For help, refer to the <A href="http://localhost/HelpSys/ObjectRef/ZGDChart/hs_main">Zope help system</A>
	'''

        __constructor__ = manage_addZGDChart

	def manage_edit(self, title, xtitle, ytitle, width, height, chart_type, option=[], REQUEST=None):
		"""edit ZGDChart

		'Area_3D',
		'Bar_3D',
		'Line_3D',
		'Pie_3D',
		'Hi_Lo_Close_3D',
		'Combo_Line_Area_3D',
		'Combo_Line_Bar_3D',
		'Combo_HLC_Area_3D',
		'Combo_HLC_Bar_3D',
		'Area_2D',
		'Bar_2D',
		'Line_2D',
		'Pie_2D',
		'Hi_Lo_Close_2D',
		'Combo_Line_Area_2D',
		'Combo_Line_Bar_2D',
		'Combo_HLC_Area_2D',
		'Combo_HLC_Bar_2D'

                """

	def manage_editColor(self, bg_color, edge_color, grid_color, plot_color,
						 title_color, xtitle_color, ytitle_color, ytitle2_color,
						 xlabel_color, ylabel_color, ylabel2_color, set_color_list,
						 pie_color_list,
						 REQUEST=None):
		""" edit ZGDChart colors
			all values to be passed as strings in hex, eg..
			manage_editColor(bg_color = "0xFFFFFF")
		"""

	def manage_editScale(self,
				 requested_ymax=None, requested_ymin=None, requested_yinterval=None,
				 xlabel_spacing=5, ylabel_density=80,
				 ylabel_fmt='', ylabel2_fmt='', REQUEST=None):
		""" edit ZGDChart scale properties """		

	def manage_changeDataMethod(self, data_method, REQUEST=None):
		"""change Data Method"""

	def manage_selectSQL(self, SQL, REQUEST=None):
		"""select SQL"""

	def __call__(self, mapping={}, **kwargs):
		''' Just another version of __str__ '''

	# following routines are inspired by Arpad Kiss's chart product
	def __str__(self,REQUEST=None,RESPONSE=None):
		"""
		Returns a string representation of the object <IMG SRC=xxx>
		"""
	
	def index_html(self,REQUEST=None,RESPONSE=None):
		"""
		This is the default method.
		"""
		#
		# The default chart type can be overridden by passing
		# zgdchart_runtime_type = 'Bar_2D' etc.
		#
		if REQUEST:
			if hasattr(REQUEST, self.runtime_prefix + 'type'):
				return self._chart(ZGDChart.chart_type_codes[REQUEST[self.runtime_prefix + 'type']], RESPONSE)		
		#
		# return the default chart
		#
		return self._chart(ZGDChart.chart_type_codes[self.chart_type], RESPONSE)

	#
	#	Methods of a ZGDChart instance
	#	returns a chart
	#
	#	The first few methods area inconsistent
	#	in their implementations of 2D and 3D
	#	charts. Leave them unchanged to preserve
	#	backward compatibility
	#
	def Area(self, REQUEST=None, RESPONSE=None):
		"""
		Renders dataset as a bar chart
		Deprecated
		"""

	def Bar(self, REQUEST=None, RESPONSE=None):
		"""
		Renders dataset as a bar chart
		Deprecated
		"""

	def Line(self,REQUEST=None,RESPONSE=None):
		"""
		Renders dataset as a line chart
		Deprecated
		"""

	def Pie(self,REQUEST=None,RESPONSE=None):
		"""
		Renders dataset as a pie chart
		Deprecated
		"""

	#
	#	Implements the new naming API
	#

	def Area_2D(self, REQUEST=None, RESPONSE=None):
		"""
		Renders dataset as a bar chart
		"""

	def Bar_2D(self, REQUEST=None, RESPONSE=None):
		"""
		Renders dataset as a bar chart
		"""

	def Line_2D(self,REQUEST=None,RESPONSE=None):
		"""
		Renders dataset as a line chart
		"""

	def Pie_2D(self, REQUEST=None, RESPONSE=None):
		"""
		Renders dataset as a 2D pie chart
		"""
			
	def Area_3D(self, REQUEST=None, RESPONSE=None):
		"""
		Renders dataset as a 3D area chart
		"""
			
	def Bar_3D(self, REQUEST=None, RESPONSE=None):
		"""
		Renders dataset as a 3D bar chart
		"""

	def Line_3D(self, REQUEST=None, RESPONSE=None):
		"""
		Renders dataset as a 3D line chart
		"""
			
	def Pie_3D(self, REQUEST=None, RESPONSE=None):
		"""
		Renders dataset as a 3D pie chart
		"""

	#	XXX To do: Hack chartdata to
	#	           handle hi lo close charts
	#
	def Hi_Lo_Close_2D(self, REQUEST=None, RESPONSE=None):
		"""
		Renders dataset as a hi lo close chart
		(Not supported yet)
		"""
	
	def Hi_Lo_Close_3D(self, REQUEST=None, RESPONSE=None):
		"""
		Renders dataset as a 3D combo of Hi_Lo_Close
		"""
		return self._chart(GDC_3DHILOCLOSE, RESPONSE)

	#	XXX To do: Hack chartdata to
	#	           handle combo charts
	#
	def Combo_Line_Area_2D(self, REQUEST=None, RESPONSE=None):
		"""
		Renders dataset as a combo of line and area chart
		"""

	def Combo_Line_Bar_2D(self, REQUEST=None, RESPONSE=None):
		"""
		Renders dataset as a combo of line and bar chart
		"""

	def Combo_HLC_Area_2D(self, REQUEST=None, RESPONSE=None):
		"""
		Renders dataset as a combo of hi lo close and area chart
		"""

	def Combo_HLC_Bar_2D(self, REQUEST=None, RESPONSE=None):
		"""
		Renders dataset as a combo of hi lo close and bar chart
		"""

	def Combo_Line_Area_3D(self, REQUEST=None, RESPONSE=None):
		"""
		Renders dataset as a 3D combo of line and area chart
		"""
			
	def Combo_Line_Bar_3D(self, REQUEST=None, RESPONSE=None):
		"""
		Renders dataset as a 3D combo of line and area bar
		"""
			
	def Combo_HLC_Area_3D(self, REQUEST=None, RESPONSE=None):
		"""
		Renders dataset as a 3D combo of HLC and area chart
		"""
			
	def Combo_HLC_Bar_3D(self, REQUEST=None, RESPONSE=None):
		"""
		Renders dataset as a 3D combo of HLC and area bar
		"""
			
	def _chart(self, GDC_TYPE, RESPONSE=None):
		"""
		Renders dataset in the format requested
		"""

